﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.VistaPharmacyModels;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class VistaPharmacyDEAMap
    {
        public static async Task<IQueryable<VistaPharmacyDEA>> MapVistaPharmacyDEAs(List<ppms_deascheduleprivilege> ppmsDEAs,string queryType, IOrganizationService _service)
        {
            var deaList = new List<VistaPharmacyDEA> { };            
            int count = 0;
            
            foreach (var ppmsDEA in ppmsDEAs)
            {
                count += 1;                         
                var dea = new VistaPharmacyDEA
                {
                    DeaNumber = Int32.Parse(ppmsDEA.ppms_deanumber),
                    Verifier = ppmsDEA.ppms_verifier

                };


                if (ppmsDEA.ppms_verificationdate != null)
                {
                    dea.VerificationDate = ppmsDEA.ppms_verificationdate.Value;
                }
                if (ppmsDEA.ppms_expirationdate != null)
                {
                    dea.ExpirationDate = ppmsDEA.ppms_expirationdate.Value;
                }
                if (ppmsDEA.ppms_associatedlocation != null)
                {
                    dea.AssociatedLocationName = ppmsDEA.ppms_associatedlocation.Name;
                }
                dea.HasSchedule2 = ppmsDEA.ppms_hasscheduleii.Value;
                dea.HasSchedule2NonNarcotic = ppmsDEA.ppms_hasscheduleiinonnarcotic.Value;
                dea.HasSchedule3 = ppmsDEA.ppms_hasscheduleiii.Value;
                dea.HasSchedule3NonNarcotic = ppmsDEA.ppms_hasscheduleiiinonnarcotic.Value;
                dea.HasSchedule4 = ppmsDEA.ppms_hasscheduleiv.Value;
                dea.HasSchedule5 = ppmsDEA.ppms_hasschedulev.Value;

                //Primary Provider NPI
                if (ppmsDEA.Attributes.ContainsKey("provider.ppms_provideridentifier") == true)
                {
                    dea.ProviderNPI = (string)ppmsDEA.GetAttributeValue<AliasedValue>("provider.ppms_provideridentifier").Value;
                }


                deaList.Add(dea);              
            }          
            var deas = deaList.AsQueryable();
            return deas;
        }
    }
}